<?php
// This file was auto-generated from sdk-root/src/data/iotwireless/2020-11-22/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-11-22', 'endpointPrefix' => 'api.iotwireless', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS IoT Wireless', 'serviceId' => 'IoT Wireless', 'signatureVersion' => 'v4', 'signingName' => 'iotwireless', 'uid' => 'iotwireless-2020-11-22', ], 'operations' => [ 'AssociateAwsAccountWithPartnerAccount' => [ 'name' => 'AssociateAwsAccountWithPartnerAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/partner-accounts', ], 'input' => [ 'shape' => 'AssociateAwsAccountWithPartnerAccountRequest', ], 'output' => [ 'shape' => 'AssociateAwsAccountWithPartnerAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'AssociateWirelessDeviceWithThing' => [ 'name' => 'AssociateWirelessDeviceWithThing', 'http' => [ 'method' => 'PUT', 'requestUri' => '/wireless-devices/{Id}/thing', 'responseCode' => 204, ], 'input' => [ 'shape' => 'AssociateWirelessDeviceWithThingRequest', ], 'output' => [ 'shape' => 'AssociateWirelessDeviceWithThingResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'AssociateWirelessGatewayWithCertificate' => [ 'name' => 'AssociateWirelessGatewayWithCertificate', 'http' => [ 'method' => 'PUT', 'requestUri' => '/wireless-gateways/{Id}/certificate', ], 'input' => [ 'shape' => 'AssociateWirelessGatewayWithCertificateRequest', ], 'output' => [ 'shape' => 'AssociateWirelessGatewayWithCertificateResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'AssociateWirelessGatewayWithThing' => [ 'name' => 'AssociateWirelessGatewayWithThing', 'http' => [ 'method' => 'PUT', 'requestUri' => '/wireless-gateways/{Id}/thing', 'responseCode' => 204, ], 'input' => [ 'shape' => 'AssociateWirelessGatewayWithThingRequest', ], 'output' => [ 'shape' => 'AssociateWirelessGatewayWithThingResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateDestination' => [ 'name' => 'CreateDestination', 'http' => [ 'method' => 'POST', 'requestUri' => '/destinations', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDestinationRequest', ], 'output' => [ 'shape' => 'CreateDestinationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateDeviceProfile' => [ 'name' => 'CreateDeviceProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/device-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDeviceProfileRequest', ], 'output' => [ 'shape' => 'CreateDeviceProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateServiceProfile' => [ 'name' => 'CreateServiceProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/service-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateServiceProfileRequest', ], 'output' => [ 'shape' => 'CreateServiceProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateWirelessDevice' => [ 'name' => 'CreateWirelessDevice', 'http' => [ 'method' => 'POST', 'requestUri' => '/wireless-devices', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWirelessDeviceRequest', ], 'output' => [ 'shape' => 'CreateWirelessDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateWirelessGateway' => [ 'name' => 'CreateWirelessGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/wireless-gateways', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWirelessGatewayRequest', ], 'output' => [ 'shape' => 'CreateWirelessGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateWirelessGatewayTask' => [ 'name' => 'CreateWirelessGatewayTask', 'http' => [ 'method' => 'POST', 'requestUri' => '/wireless-gateways/{Id}/tasks', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWirelessGatewayTaskRequest', ], 'output' => [ 'shape' => 'CreateWirelessGatewayTaskResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateWirelessGatewayTaskDefinition' => [ 'name' => 'CreateWirelessGatewayTaskDefinition', 'http' => [ 'method' => 'POST', 'requestUri' => '/wireless-gateway-task-definitions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWirelessGatewayTaskDefinitionRequest', ], 'output' => [ 'shape' => 'CreateWirelessGatewayTaskDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteDestination' => [ 'name' => 'DeleteDestination', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/destinations/{Name}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteDestinationRequest', ], 'output' => [ 'shape' => 'DeleteDestinationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteDeviceProfile' => [ 'name' => 'DeleteDeviceProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/device-profiles/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteDeviceProfileRequest', ], 'output' => [ 'shape' => 'DeleteDeviceProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteServiceProfile' => [ 'name' => 'DeleteServiceProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/service-profiles/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteServiceProfileRequest', ], 'output' => [ 'shape' => 'DeleteServiceProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteWirelessDevice' => [ 'name' => 'DeleteWirelessDevice', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-devices/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWirelessDeviceRequest', ], 'output' => [ 'shape' => 'DeleteWirelessDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteWirelessGateway' => [ 'name' => 'DeleteWirelessGateway', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-gateways/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWirelessGatewayRequest', ], 'output' => [ 'shape' => 'DeleteWirelessGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteWirelessGatewayTask' => [ 'name' => 'DeleteWirelessGatewayTask', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-gateways/{Id}/tasks', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWirelessGatewayTaskRequest', ], 'output' => [ 'shape' => 'DeleteWirelessGatewayTaskResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteWirelessGatewayTaskDefinition' => [ 'name' => 'DeleteWirelessGatewayTaskDefinition', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-gateway-task-definitions/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWirelessGatewayTaskDefinitionRequest', ], 'output' => [ 'shape' => 'DeleteWirelessGatewayTaskDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DisassociateAwsAccountFromPartnerAccount' => [ 'name' => 'DisassociateAwsAccountFromPartnerAccount', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/partner-accounts/{PartnerAccountId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DisassociateAwsAccountFromPartnerAccountRequest', ], 'output' => [ 'shape' => 'DisassociateAwsAccountFromPartnerAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DisassociateWirelessDeviceFromThing' => [ 'name' => 'DisassociateWirelessDeviceFromThing', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-devices/{Id}/thing', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DisassociateWirelessDeviceFromThingRequest', ], 'output' => [ 'shape' => 'DisassociateWirelessDeviceFromThingResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DisassociateWirelessGatewayFromCertificate' => [ 'name' => 'DisassociateWirelessGatewayFromCertificate', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-gateways/{Id}/certificate', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DisassociateWirelessGatewayFromCertificateRequest', ], 'output' => [ 'shape' => 'DisassociateWirelessGatewayFromCertificateResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DisassociateWirelessGatewayFromThing' => [ 'name' => 'DisassociateWirelessGatewayFromThing', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/wireless-gateways/{Id}/thing', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DisassociateWirelessGatewayFromThingRequest', ], 'output' => [ 'shape' => 'DisassociateWirelessGatewayFromThingResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDestination' => [ 'name' => 'GetDestination', 'http' => [ 'method' => 'GET', 'requestUri' => '/destinations/{Name}', ], 'input' => [ 'shape' => 'GetDestinationRequest', ], 'output' => [ 'shape' => 'GetDestinationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetDeviceProfile' => [ 'name' => 'GetDeviceProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/device-profiles/{Id}', ], 'input' => [ 'shape' => 'GetDeviceProfileRequest', ], 'output' => [ 'shape' => 'GetDeviceProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetPartnerAccount' => [ 'name' => 'GetPartnerAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/partner-accounts/{PartnerAccountId}', ], 'input' => [ 'shape' => 'GetPartnerAccountRequest', ], 'output' => [ 'shape' => 'GetPartnerAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetServiceEndpoint' => [ 'name' => 'GetServiceEndpoint', 'http' => [ 'method' => 'GET', 'requestUri' => '/service-endpoint', ], 'input' => [ 'shape' => 'GetServiceEndpointRequest', ], 'output' => [ 'shape' => 'GetServiceEndpointResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetServiceProfile' => [ 'name' => 'GetServiceProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/service-profiles/{Id}', ], 'input' => [ 'shape' => 'GetServiceProfileRequest', ], 'output' => [ 'shape' => 'GetServiceProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessDevice' => [ 'name' => 'GetWirelessDevice', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-devices/{Identifier}', ], 'input' => [ 'shape' => 'GetWirelessDeviceRequest', ], 'output' => [ 'shape' => 'GetWirelessDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessDeviceStatistics' => [ 'name' => 'GetWirelessDeviceStatistics', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-devices/{Id}/statistics', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWirelessDeviceStatisticsRequest', ], 'output' => [ 'shape' => 'GetWirelessDeviceStatisticsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessGateway' => [ 'name' => 'GetWirelessGateway', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateways/{Identifier}', ], 'input' => [ 'shape' => 'GetWirelessGatewayRequest', ], 'output' => [ 'shape' => 'GetWirelessGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessGatewayCertificate' => [ 'name' => 'GetWirelessGatewayCertificate', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateways/{Id}/certificate', ], 'input' => [ 'shape' => 'GetWirelessGatewayCertificateRequest', ], 'output' => [ 'shape' => 'GetWirelessGatewayCertificateResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessGatewayFirmwareInformation' => [ 'name' => 'GetWirelessGatewayFirmwareInformation', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateways/{Id}/firmware-information', ], 'input' => [ 'shape' => 'GetWirelessGatewayFirmwareInformationRequest', ], 'output' => [ 'shape' => 'GetWirelessGatewayFirmwareInformationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessGatewayStatistics' => [ 'name' => 'GetWirelessGatewayStatistics', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateways/{Id}/statistics', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWirelessGatewayStatisticsRequest', ], 'output' => [ 'shape' => 'GetWirelessGatewayStatisticsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessGatewayTask' => [ 'name' => 'GetWirelessGatewayTask', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateways/{Id}/tasks', ], 'input' => [ 'shape' => 'GetWirelessGatewayTaskRequest', ], 'output' => [ 'shape' => 'GetWirelessGatewayTaskResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetWirelessGatewayTaskDefinition' => [ 'name' => 'GetWirelessGatewayTaskDefinition', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateway-task-definitions/{Id}', ], 'input' => [ 'shape' => 'GetWirelessGatewayTaskDefinitionRequest', ], 'output' => [ 'shape' => 'GetWirelessGatewayTaskDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListDestinations' => [ 'name' => 'ListDestinations', 'http' => [ 'method' => 'GET', 'requestUri' => '/destinations', ], 'input' => [ 'shape' => 'ListDestinationsRequest', ], 'output' => [ 'shape' => 'ListDestinationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListDeviceProfiles' => [ 'name' => 'ListDeviceProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/device-profiles', ], 'input' => [ 'shape' => 'ListDeviceProfilesRequest', ], 'output' => [ 'shape' => 'ListDeviceProfilesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListPartnerAccounts' => [ 'name' => 'ListPartnerAccounts', 'http' => [ 'method' => 'GET', 'requestUri' => '/partner-accounts', ], 'input' => [ 'shape' => 'ListPartnerAccountsRequest', ], 'output' => [ 'shape' => 'ListPartnerAccountsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListServiceProfiles' => [ 'name' => 'ListServiceProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/service-profiles', ], 'input' => [ 'shape' => 'ListServiceProfilesRequest', ], 'output' => [ 'shape' => 'ListServiceProfilesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListWirelessDevices' => [ 'name' => 'ListWirelessDevices', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-devices', ], 'input' => [ 'shape' => 'ListWirelessDevicesRequest', ], 'output' => [ 'shape' => 'ListWirelessDevicesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListWirelessGatewayTaskDefinitions' => [ 'name' => 'ListWirelessGatewayTaskDefinitions', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateway-task-definitions', ], 'input' => [ 'shape' => 'ListWirelessGatewayTaskDefinitionsRequest', ], 'output' => [ 'shape' => 'ListWirelessGatewayTaskDefinitionsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListWirelessGateways' => [ 'name' => 'ListWirelessGateways', 'http' => [ 'method' => 'GET', 'requestUri' => '/wireless-gateways', ], 'input' => [ 'shape' => 'ListWirelessGatewaysRequest', ], 'output' => [ 'shape' => 'ListWirelessGatewaysResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'SendDataToWirelessDevice' => [ 'name' => 'SendDataToWirelessDevice', 'http' => [ 'method' => 'POST', 'requestUri' => '/wireless-devices/{Id}/data', 'responseCode' => 202, ], 'input' => [ 'shape' => 'SendDataToWirelessDeviceRequest', ], 'output' => [ 'shape' => 'SendDataToWirelessDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags', 'responseCode' => 204, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'TooManyTagsException', ], ], ], 'TestWirelessDevice' => [ 'name' => 'TestWirelessDevice', 'http' => [ 'method' => 'POST', 'requestUri' => '/wireless-devices/{Id}/test', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TestWirelessDeviceRequest', ], 'output' => [ 'shape' => 'TestWirelessDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateDestination' => [ 'name' => 'UpdateDestination', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/destinations/{Name}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateDestinationRequest', ], 'output' => [ 'shape' => 'UpdateDestinationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdatePartnerAccount' => [ 'name' => 'UpdatePartnerAccount', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/partner-accounts/{PartnerAccountId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdatePartnerAccountRequest', ], 'output' => [ 'shape' => 'UpdatePartnerAccountResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateWirelessDevice' => [ 'name' => 'UpdateWirelessDevice', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/wireless-devices/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateWirelessDeviceRequest', ], 'output' => [ 'shape' => 'UpdateWirelessDeviceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateWirelessGateway' => [ 'name' => 'UpdateWirelessGateway', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/wireless-gateways/{Id}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateWirelessGatewayRequest', ], 'output' => [ 'shape' => 'UpdateWirelessGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], ], 'shapes' => [ 'AbpV1_0_x' => [ 'type' => 'structure', 'members' => [ 'DevAddr' => [ 'shape' => 'DevAddr', ], 'SessionKeys' => [ 'shape' => 'SessionKeysAbpV1_0_x', ], ], ], 'AbpV1_1' => [ 'type' => 'structure', 'members' => [ 'DevAddr' => [ 'shape' => 'DevAddr', ], 'SessionKeys' => [ 'shape' => 'SessionKeysAbpV1_1', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccountLinked' => [ 'type' => 'boolean', ], 'AddGwMetadata' => [ 'type' => 'boolean', ], 'AmazonId' => [ 'type' => 'string', 'max' => 2048, ], 'AmazonResourceName' => [ 'type' => 'string', 'max' => 1011, 'min' => 1, ], 'AppEui' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{16}', ], 'AppKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'AppSKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'AppServerPrivateKey' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'pattern' => '[a-fA-F0-9]{64}', 'sensitive' => true, ], 'AssociateAwsAccountWithPartnerAccountRequest' => [ 'type' => 'structure', 'required' => [ 'Sidewalk', ], 'members' => [ 'Sidewalk' => [ 'shape' => 'SidewalkAccountInfo', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'AssociateAwsAccountWithPartnerAccountResponse' => [ 'type' => 'structure', 'members' => [ 'Sidewalk' => [ 'shape' => 'SidewalkAccountInfo', ], 'Arn' => [ 'shape' => 'PartnerAccountArn', ], ], ], 'AssociateWirelessDeviceWithThingRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'ThingArn', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], 'ThingArn' => [ 'shape' => 'ThingArn', ], ], ], 'AssociateWirelessDeviceWithThingResponse' => [ 'type' => 'structure', 'members' => [], ], 'AssociateWirelessGatewayWithCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'IotCertificateId', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], 'IotCertificateId' => [ 'shape' => 'IotCertificateId', ], ], ], 'AssociateWirelessGatewayWithCertificateResponse' => [ 'type' => 'structure', 'members' => [ 'IotCertificateId' => [ 'shape' => 'IotCertificateId', ], ], ], 'AssociateWirelessGatewayWithThingRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'ThingArn', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], 'ThingArn' => [ 'shape' => 'ThingArn', ], ], ], 'AssociateWirelessGatewayWithThingResponse' => [ 'type' => 'structure', 'members' => [], ], 'AutoCreateTasks' => [ 'type' => 'boolean', ], 'CertificatePEM' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'pattern' => '[^-A-Za-z0-9+/=]|=[^=]|={3,}${1,4096}', ], 'ChannelMask' => [ 'type' => 'string', 'max' => 2048, ], 'ClassBTimeout' => [ 'type' => 'integer', 'max' => 1000, 'min' => 0, ], 'ClassCTimeout' => [ 'type' => 'integer', 'max' => 1000, 'min' => 0, ], 'ClientRequestToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '^[a-zA-Z0-9-_]+$', ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], 'ResourceId' => [ 'shape' => 'ResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'Crc' => [ 'type' => 'long', 'max' => 4294967295, 'min' => 1, ], 'CreateDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'ExpressionType', 'Expression', 'RoleArn', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', ], 'ExpressionType' => [ 'shape' => 'ExpressionType', ], 'Expression' => [ 'shape' => 'Expression', ], 'Description' => [ 'shape' => 'Description', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'Tags' => [ 'shape' => 'TagList', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateDestinationResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'DestinationArn', ], 'Name' => [ 'shape' => 'DestinationName', ], ], ], 'CreateDeviceProfileRequest' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DeviceProfileName', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANDeviceProfile', ], 'Tags' => [ 'shape' => 'TagList', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateDeviceProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'DeviceProfileArn', ], 'Id' => [ 'shape' => 'DeviceProfileId', ], ], ], 'CreateServiceProfileRequest' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'ServiceProfileName', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANServiceProfile', ], 'Tags' => [ 'shape' => 'TagList', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateServiceProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ServiceProfileArn', ], 'Id' => [ 'shape' => 'ServiceProfileId', ], ], ], 'CreateWirelessDeviceRequest' => [ 'type' => 'structure', 'required' => [ 'Type', 'DestinationName', ], 'members' => [ 'Type' => [ 'shape' => 'WirelessDeviceType', ], 'Name' => [ 'shape' => 'WirelessDeviceName', ], 'Description' => [ 'shape' => 'Description', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'LoRaWAN' => [ 'shape' => 'LoRaWANDevice', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateWirelessDeviceResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'WirelessDeviceArn', ], 'Id' => [ 'shape' => 'WirelessDeviceId', ], ], ], 'CreateWirelessGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'LoRaWAN', ], 'members' => [ 'Name' => [ 'shape' => 'WirelessGatewayName', ], 'Description' => [ 'shape' => 'Description', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANGateway', ], 'Tags' => [ 'shape' => 'TagList', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateWirelessGatewayResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'WirelessGatewayArn', ], 'Id' => [ 'shape' => 'WirelessDeviceId', ], ], ], 'CreateWirelessGatewayTaskDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'AutoCreateTasks', ], 'members' => [ 'AutoCreateTasks' => [ 'shape' => 'AutoCreateTasks', ], 'Name' => [ 'shape' => 'WirelessGatewayTaskName', ], 'Update' => [ 'shape' => 'UpdateWirelessGatewayTaskCreate', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'CreateWirelessGatewayTaskDefinitionResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', ], 'Arn' => [ 'shape' => 'WirelessGatewayTaskDefinitionArn', ], ], ], 'CreateWirelessGatewayTaskRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'WirelessGatewayTaskDefinitionId', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], 'WirelessGatewayTaskDefinitionId' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', ], ], ], 'CreateWirelessGatewayTaskResponse' => [ 'type' => 'structure', 'members' => [ 'WirelessGatewayTaskDefinitionId' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', ], 'Status' => [ 'shape' => 'WirelessGatewayTaskStatus', ], ], ], 'DeleteDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', 'location' => 'uri', 'locationName' => 'Name', ], ], ], 'DeleteDestinationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDeviceProfileRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'DeviceProfileId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteDeviceProfileResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteServiceProfileRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ServiceProfileId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteServiceProfileResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteWirelessDeviceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteWirelessDeviceResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteWirelessGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteWirelessGatewayResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteWirelessGatewayTaskDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteWirelessGatewayTaskDefinitionResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteWirelessGatewayTaskRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteWirelessGatewayTaskResponse' => [ 'type' => 'structure', 'members' => [], ], 'Description' => [ 'type' => 'string', 'max' => 2048, ], 'DestinationArn' => [ 'type' => 'string', ], 'DestinationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Destinations', ], ], 'DestinationName' => [ 'type' => 'string', 'max' => 128, 'pattern' => '[a-zA-Z0-9-_]+', ], 'Destinations' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'DestinationArn', ], 'Name' => [ 'shape' => 'DestinationName', ], 'ExpressionType' => [ 'shape' => 'ExpressionType', ], 'Expression' => [ 'shape' => 'Expression', ], 'Description' => [ 'shape' => 'Description', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], ], ], 'DevAddr' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{8}', ], 'DevEui' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{16}', ], 'DevStatusReqFreq' => [ 'type' => 'integer', 'max' => 2147483647, 'min' => 0, ], 'DeviceProfile' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'DeviceProfileArn', ], 'Name' => [ 'shape' => 'DeviceProfileName', ], 'Id' => [ 'shape' => 'DeviceProfileId', ], ], ], 'DeviceProfileArn' => [ 'type' => 'string', ], 'DeviceProfileId' => [ 'type' => 'string', 'max' => 256, ], 'DeviceProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DeviceProfile', ], ], 'DeviceProfileName' => [ 'type' => 'string', 'max' => 256, ], 'DisassociateAwsAccountFromPartnerAccountRequest' => [ 'type' => 'structure', 'required' => [ 'PartnerAccountId', 'PartnerType', ], 'members' => [ 'PartnerAccountId' => [ 'shape' => 'PartnerAccountId', 'location' => 'uri', 'locationName' => 'PartnerAccountId', ], 'PartnerType' => [ 'shape' => 'PartnerType', 'location' => 'querystring', 'locationName' => 'partnerType', ], ], ], 'DisassociateAwsAccountFromPartnerAccountResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateWirelessDeviceFromThingRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DisassociateWirelessDeviceFromThingResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateWirelessGatewayFromCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DisassociateWirelessGatewayFromCertificateResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateWirelessGatewayFromThingRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DisassociateWirelessGatewayFromThingResponse' => [ 'type' => 'structure', 'members' => [], ], 'DlBucketSize' => [ 'type' => 'integer', 'max' => 2147483647, 'min' => 0, ], 'DlRate' => [ 'type' => 'integer', 'max' => 2147483647, 'min' => 0, ], 'DlRatePolicy' => [ 'type' => 'string', 'max' => 256, ], 'Double' => [ 'type' => 'double', ], 'DrMax' => [ 'type' => 'integer', 'max' => 15, 'min' => 0, ], 'DrMin' => [ 'type' => 'integer', 'max' => 15, 'min' => 0, ], 'EndPoint' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'Expression' => [ 'type' => 'string', 'max' => 2048, ], 'ExpressionType' => [ 'type' => 'string', 'enum' => [ 'RuleName', 'MqttTopic', ], ], 'FNwkSIntKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'FPort' => [ 'type' => 'integer', 'max' => 223, 'min' => 1, ], 'FactoryPresetFreqsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PresetFreq', ], 'max' => 20, 'min' => 0, ], 'Fingerprint' => [ 'type' => 'string', 'max' => 64, 'min' => 64, 'pattern' => '[a-fA-F0-9]{64}', 'sensitive' => true, ], 'GatewayEui' => [ 'type' => 'string', 'pattern' => '^(([0-9A-Fa-f]{2}-){7}|([0-9A-Fa-f]{2}:){7}|([0-9A-Fa-f]{2}\\s){7}|([0-9A-Fa-f]{2}){7})([0-9A-Fa-f]{2})$', ], 'GetDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', 'location' => 'uri', 'locationName' => 'Name', ], ], ], 'GetDestinationResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'DestinationArn', ], 'Name' => [ 'shape' => 'DestinationName', ], 'Expression' => [ 'shape' => 'Expression', ], 'ExpressionType' => [ 'shape' => 'ExpressionType', ], 'Description' => [ 'shape' => 'Description', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], ], ], 'GetDeviceProfileRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'DeviceProfileId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetDeviceProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'DeviceProfileArn', ], 'Name' => [ 'shape' => 'DeviceProfileName', ], 'Id' => [ 'shape' => 'DeviceProfileId', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANDeviceProfile', ], ], ], 'GetPartnerAccountRequest' => [ 'type' => 'structure', 'required' => [ 'PartnerAccountId', 'PartnerType', ], 'members' => [ 'PartnerAccountId' => [ 'shape' => 'PartnerAccountId', 'location' => 'uri', 'locationName' => 'PartnerAccountId', ], 'PartnerType' => [ 'shape' => 'PartnerType', 'location' => 'querystring', 'locationName' => 'partnerType', ], ], ], 'GetPartnerAccountResponse' => [ 'type' => 'structure', 'members' => [ 'Sidewalk' => [ 'shape' => 'SidewalkAccountInfoWithFingerprint', ], 'AccountLinked' => [ 'shape' => 'AccountLinked', ], ], ], 'GetServiceEndpointRequest' => [ 'type' => 'structure', 'members' => [ 'ServiceType' => [ 'shape' => 'WirelessGatewayServiceType', 'location' => 'querystring', 'locationName' => 'serviceType', ], ], ], 'GetServiceEndpointResponse' => [ 'type' => 'structure', 'members' => [ 'ServiceType' => [ 'shape' => 'WirelessGatewayServiceType', ], 'ServiceEndpoint' => [ 'shape' => 'EndPoint', ], 'ServerTrust' => [ 'shape' => 'CertificatePEM', ], ], ], 'GetServiceProfileRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ServiceProfileId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetServiceProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ServiceProfileArn', ], 'Name' => [ 'shape' => 'ServiceProfileName', ], 'Id' => [ 'shape' => 'ServiceProfileId', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANGetServiceProfileInfo', ], ], ], 'GetWirelessDeviceRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', 'IdentifierType', ], 'members' => [ 'Identifier' => [ 'shape' => 'Identifier', 'location' => 'uri', 'locationName' => 'Identifier', ], 'IdentifierType' => [ 'shape' => 'WirelessDeviceIdType', 'location' => 'querystring', 'locationName' => 'identifierType', ], ], ], 'GetWirelessDeviceResponse' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'WirelessDeviceType', ], 'Name' => [ 'shape' => 'WirelessDeviceName', ], 'Description' => [ 'shape' => 'Description', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], 'Id' => [ 'shape' => 'WirelessDeviceId', ], 'Arn' => [ 'shape' => 'WirelessDeviceArn', ], 'ThingName' => [ 'shape' => 'ThingName', ], 'ThingArn' => [ 'shape' => 'ThingArn', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANDevice', ], ], ], 'GetWirelessDeviceStatisticsRequest' => [ 'type' => 'structure', 'required' => [ 'WirelessDeviceId', ], 'members' => [ 'WirelessDeviceId' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetWirelessDeviceStatisticsResponse' => [ 'type' => 'structure', 'members' => [ 'WirelessDeviceId' => [ 'shape' => 'WirelessDeviceId', ], 'LastUplinkReceivedAt' => [ 'shape' => 'ISODateTimeString', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANDeviceMetadata', ], ], ], 'GetWirelessGatewayCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetWirelessGatewayCertificateResponse' => [ 'type' => 'structure', 'members' => [ 'IotCertificateId' => [ 'shape' => 'IotCertificateId', ], 'LoRaWANNetworkServerCertificateId' => [ 'shape' => 'IotCertificateId', ], ], ], 'GetWirelessGatewayFirmwareInformationRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetWirelessGatewayFirmwareInformationResponse' => [ 'type' => 'structure', 'members' => [ 'LoRaWAN' => [ 'shape' => 'LoRaWANGatewayCurrentVersion', ], ], ], 'GetWirelessGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', 'IdentifierType', ], 'members' => [ 'Identifier' => [ 'shape' => 'Identifier', 'location' => 'uri', 'locationName' => 'Identifier', ], 'IdentifierType' => [ 'shape' => 'WirelessGatewayIdType', 'location' => 'querystring', 'locationName' => 'identifierType', ], ], ], 'GetWirelessGatewayResponse' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'WirelessGatewayName', ], 'Id' => [ 'shape' => 'WirelessGatewayId', ], 'Description' => [ 'shape' => 'Description', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANGateway', ], 'Arn' => [ 'shape' => 'WirelessGatewayArn', ], 'ThingName' => [ 'shape' => 'ThingName', ], 'ThingArn' => [ 'shape' => 'ThingArn', ], ], ], 'GetWirelessGatewayStatisticsRequest' => [ 'type' => 'structure', 'required' => [ 'WirelessGatewayId', ], 'members' => [ 'WirelessGatewayId' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetWirelessGatewayStatisticsResponse' => [ 'type' => 'structure', 'members' => [ 'WirelessGatewayId' => [ 'shape' => 'WirelessGatewayId', ], 'LastUplinkReceivedAt' => [ 'shape' => 'ISODateTimeString', ], ], ], 'GetWirelessGatewayTaskDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetWirelessGatewayTaskDefinitionResponse' => [ 'type' => 'structure', 'members' => [ 'AutoCreateTasks' => [ 'shape' => 'AutoCreateTasks', ], 'Name' => [ 'shape' => 'WirelessGatewayTaskName', ], 'Update' => [ 'shape' => 'UpdateWirelessGatewayTaskCreate', ], 'Arn' => [ 'shape' => 'WirelessGatewayTaskDefinitionArn', ], ], ], 'GetWirelessGatewayTaskRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetWirelessGatewayTaskResponse' => [ 'type' => 'structure', 'members' => [ 'WirelessGatewayId' => [ 'shape' => 'WirelessGatewayId', ], 'WirelessGatewayTaskDefinitionId' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', ], 'LastUplinkReceivedAt' => [ 'shape' => 'ISODateTimeString', ], 'TaskCreatedAt' => [ 'shape' => 'ISODateTimeString', ], 'Status' => [ 'shape' => 'WirelessGatewayTaskStatus', ], ], ], 'HrAllowed' => [ 'type' => 'boolean', ], 'ISODateTimeString' => [ 'type' => 'string', 'pattern' => '^([\\+-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d+(?!:))?)?(\\17[0-5]\\d([\\.,]\\d+)?)?([zZ]|([\\+-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$', ], 'Identifier' => [ 'type' => 'string', 'max' => 256, ], 'Integer' => [ 'type' => 'integer', ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, ], 'IotCertificateId' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'JoinEui' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{16}', ], 'ListDestinationsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListDestinationsResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'DestinationList' => [ 'shape' => 'DestinationList', ], ], ], 'ListDeviceProfilesRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListDeviceProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'DeviceProfileList' => [ 'shape' => 'DeviceProfileList', ], ], ], 'ListPartnerAccountsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListPartnerAccountsResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'Sidewalk' => [ 'shape' => 'SidewalkAccountList', ], ], ], 'ListServiceProfilesRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListServiceProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'ServiceProfileList' => [ 'shape' => 'ServiceProfileList', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'AmazonResourceName', 'location' => 'querystring', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'Tags' => [ 'shape' => 'TagList', ], ], ], 'ListWirelessDevicesRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'DestinationName' => [ 'shape' => 'DestinationName', 'location' => 'querystring', 'locationName' => 'destinationName', ], 'DeviceProfileId' => [ 'shape' => 'DeviceProfileId', 'location' => 'querystring', 'locationName' => 'deviceProfileId', ], 'ServiceProfileId' => [ 'shape' => 'ServiceProfileId', 'location' => 'querystring', 'locationName' => 'serviceProfileId', ], 'WirelessDeviceType' => [ 'shape' => 'WirelessDeviceType', 'location' => 'querystring', 'locationName' => 'wirelessDeviceType', ], ], ], 'ListWirelessDevicesResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'WirelessDeviceList' => [ 'shape' => 'WirelessDeviceStatisticsList', ], ], ], 'ListWirelessGatewayTaskDefinitionsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'TaskDefinitionType' => [ 'shape' => 'WirelessGatewayTaskDefinitionType', 'location' => 'querystring', 'locationName' => 'taskDefinitionType', ], ], ], 'ListWirelessGatewayTaskDefinitionsResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'TaskDefinitions' => [ 'shape' => 'WirelessGatewayTaskDefinitionList', ], ], ], 'ListWirelessGatewaysRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListWirelessGatewaysResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'WirelessGatewayList' => [ 'shape' => 'WirelessGatewayStatisticsList', ], ], ], 'LoRaWANDevice' => [ 'type' => 'structure', 'members' => [ 'DevEui' => [ 'shape' => 'DevEui', ], 'DeviceProfileId' => [ 'shape' => 'DeviceProfileId', ], 'ServiceProfileId' => [ 'shape' => 'ServiceProfileId', ], 'OtaaV1_1' => [ 'shape' => 'OtaaV1_1', ], 'OtaaV1_0_x' => [ 'shape' => 'OtaaV1_0_x', ], 'AbpV1_1' => [ 'shape' => 'AbpV1_1', ], 'AbpV1_0_x' => [ 'shape' => 'AbpV1_0_x', ], ], ], 'LoRaWANDeviceMetadata' => [ 'type' => 'structure', 'members' => [ 'DevEui' => [ 'shape' => 'DevEui', ], 'FPort' => [ 'shape' => 'Integer', ], 'DataRate' => [ 'shape' => 'Integer', ], 'Frequency' => [ 'shape' => 'Integer', ], 'Timestamp' => [ 'shape' => 'ISODateTimeString', ], 'Gateways' => [ 'shape' => 'LoRaWANGatewayMetadataList', ], ], ], 'LoRaWANDeviceProfile' => [ 'type' => 'structure', 'members' => [ 'SupportsClassB' => [ 'shape' => 'SupportsClassB', ], 'ClassBTimeout' => [ 'shape' => 'ClassBTimeout', ], 'PingSlotPeriod' => [ 'shape' => 'PingSlotPeriod', ], 'PingSlotDr' => [ 'shape' => 'PingSlotDr', ], 'PingSlotFreq' => [ 'shape' => 'PingSlotFreq', ], 'SupportsClassC' => [ 'shape' => 'SupportsClassC', ], 'ClassCTimeout' => [ 'shape' => 'ClassCTimeout', ], 'MacVersion' => [ 'shape' => 'MacVersion', ], 'RegParamsRevision' => [ 'shape' => 'RegParamsRevision', ], 'RxDelay1' => [ 'shape' => 'RxDelay1', ], 'RxDrOffset1' => [ 'shape' => 'RxDrOffset1', ], 'RxDataRate2' => [ 'shape' => 'RxDataRate2', ], 'RxFreq2' => [ 'shape' => 'RxFreq2', ], 'FactoryPresetFreqsList' => [ 'shape' => 'FactoryPresetFreqsList', ], 'MaxEirp' => [ 'shape' => 'MaxEirp', ], 'MaxDutyCycle' => [ 'shape' => 'MaxDutyCycle', ], 'RfRegion' => [ 'shape' => 'RfRegion', ], 'SupportsJoin' => [ 'shape' => 'SupportsJoin', ], 'Supports32BitFCnt' => [ 'shape' => 'Supports32BitFCnt', ], ], ], 'LoRaWANGateway' => [ 'type' => 'structure', 'members' => [ 'GatewayEui' => [ 'shape' => 'GatewayEui', ], 'RfRegion' => [ 'shape' => 'RfRegion', ], ], ], 'LoRaWANGatewayCurrentVersion' => [ 'type' => 'structure', 'members' => [ 'CurrentVersion' => [ 'shape' => 'LoRaWANGatewayVersion', ], ], ], 'LoRaWANGatewayMetadata' => [ 'type' => 'structure', 'members' => [ 'GatewayEui' => [ 'shape' => 'GatewayEui', ], 'Snr' => [ 'shape' => 'Double', ], 'Rssi' => [ 'shape' => 'Double', ], ], ], 'LoRaWANGatewayMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LoRaWANGatewayMetadata', ], ], 'LoRaWANGatewayVersion' => [ 'type' => 'structure', 'members' => [ 'PackageVersion' => [ 'shape' => 'PackageVersion', ], 'Model' => [ 'shape' => 'Model', ], 'Station' => [ 'shape' => 'Station', ], ], ], 'LoRaWANGetServiceProfileInfo' => [ 'type' => 'structure', 'members' => [ 'UlRate' => [ 'shape' => 'UlRate', ], 'UlBucketSize' => [ 'shape' => 'UlBucketSize', ], 'UlRatePolicy' => [ 'shape' => 'UlRatePolicy', ], 'DlRate' => [ 'shape' => 'DlRate', ], 'DlBucketSize' => [ 'shape' => 'DlBucketSize', ], 'DlRatePolicy' => [ 'shape' => 'DlRatePolicy', ], 'AddGwMetadata' => [ 'shape' => 'AddGwMetadata', ], 'DevStatusReqFreq' => [ 'shape' => 'DevStatusReqFreq', ], 'ReportDevStatusBattery' => [ 'shape' => 'ReportDevStatusBattery', ], 'ReportDevStatusMargin' => [ 'shape' => 'ReportDevStatusMargin', ], 'DrMin' => [ 'shape' => 'DrMin', ], 'DrMax' => [ 'shape' => 'DrMax', ], 'ChannelMask' => [ 'shape' => 'ChannelMask', ], 'PrAllowed' => [ 'shape' => 'PrAllowed', ], 'HrAllowed' => [ 'shape' => 'HrAllowed', ], 'RaAllowed' => [ 'shape' => 'RaAllowed', ], 'NwkGeoLoc' => [ 'shape' => 'NwkGeoLoc', ], 'TargetPer' => [ 'shape' => 'TargetPer', ], 'MinGwDiversity' => [ 'shape' => 'MinGwDiversity', ], ], ], 'LoRaWANListDevice' => [ 'type' => 'structure', 'members' => [ 'DevEui' => [ 'shape' => 'DevEui', ], ], ], 'LoRaWANSendDataToDevice' => [ 'type' => 'structure', 'members' => [ 'FPort' => [ 'shape' => 'FPort', ], ], ], 'LoRaWANServiceProfile' => [ 'type' => 'structure', 'members' => [ 'AddGwMetadata' => [ 'shape' => 'AddGwMetadata', ], ], ], 'LoRaWANUpdateDevice' => [ 'type' => 'structure', 'members' => [ 'DeviceProfileId' => [ 'shape' => 'DeviceProfileId', ], 'ServiceProfileId' => [ 'shape' => 'ServiceProfileId', ], ], ], 'LoRaWANUpdateGatewayTaskCreate' => [ 'type' => 'structure', 'members' => [ 'UpdateSignature' => [ 'shape' => 'UpdateSignature', ], 'SigKeyCrc' => [ 'shape' => 'Crc', ], 'CurrentVersion' => [ 'shape' => 'LoRaWANGatewayVersion', ], 'UpdateVersion' => [ 'shape' => 'LoRaWANGatewayVersion', ], ], ], 'LoRaWANUpdateGatewayTaskEntry' => [ 'type' => 'structure', 'members' => [ 'CurrentVersion' => [ 'shape' => 'LoRaWANGatewayVersion', ], 'UpdateVersion' => [ 'shape' => 'LoRaWANGatewayVersion', ], ], ], 'MacVersion' => [ 'type' => 'string', 'max' => 64, ], 'MaxDutyCycle' => [ 'type' => 'integer', 'max' => 100, 'min' => 0, ], 'MaxEirp' => [ 'type' => 'integer', 'max' => 15, 'min' => 0, ], 'MaxResults' => [ 'type' => 'integer', 'max' => 250, 'min' => 0, ], 'Message' => [ 'type' => 'string', 'max' => 2048, ], 'MessageId' => [ 'type' => 'string', ], 'MinGwDiversity' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'Model' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'NextToken' => [ 'type' => 'string', 'max' => 4096, ], 'NwkGeoLoc' => [ 'type' => 'boolean', ], 'NwkKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'NwkSEncKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'NwkSKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'OtaaV1_0_x' => [ 'type' => 'structure', 'members' => [ 'AppKey' => [ 'shape' => 'AppKey', ], 'AppEui' => [ 'shape' => 'AppEui', ], ], ], 'OtaaV1_1' => [ 'type' => 'structure', 'members' => [ 'AppKey' => [ 'shape' => 'AppKey', ], 'NwkKey' => [ 'shape' => 'NwkKey', ], 'JoinEui' => [ 'shape' => 'JoinEui', ], ], ], 'PackageVersion' => [ 'type' => 'string', 'max' => 32, 'min' => 1, ], 'PartnerAccountArn' => [ 'type' => 'string', ], 'PartnerAccountId' => [ 'type' => 'string', 'max' => 256, ], 'PartnerType' => [ 'type' => 'string', 'enum' => [ 'Sidewalk', ], ], 'PayloadData' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$', ], 'PingSlotDr' => [ 'type' => 'integer', 'max' => 15, 'min' => 0, ], 'PingSlotFreq' => [ 'type' => 'integer', 'max' => 16700000, 'min' => 1000000, ], 'PingSlotPeriod' => [ 'type' => 'integer', 'max' => 4096, 'min' => 128, ], 'PrAllowed' => [ 'type' => 'boolean', ], 'PresetFreq' => [ 'type' => 'integer', 'max' => 16700000, 'min' => 1000000, ], 'RaAllowed' => [ 'type' => 'boolean', ], 'RegParamsRevision' => [ 'type' => 'string', 'max' => 64, ], 'ReportDevStatusBattery' => [ 'type' => 'boolean', ], 'ReportDevStatusMargin' => [ 'type' => 'boolean', ], 'ResourceId' => [ 'type' => 'string', ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], 'ResourceId' => [ 'shape' => 'ResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'ResourceType' => [ 'type' => 'string', ], 'Result' => [ 'type' => 'string', 'max' => 2048, ], 'RfRegion' => [ 'type' => 'string', 'max' => 64, ], 'RoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'RxDataRate2' => [ 'type' => 'integer', 'max' => 15, 'min' => 0, ], 'RxDelay1' => [ 'type' => 'integer', 'max' => 15, 'min' => 0, ], 'RxDrOffset1' => [ 'type' => 'integer', 'max' => 7, 'min' => 0, ], 'RxFreq2' => [ 'type' => 'integer', 'max' => 16700000, 'min' => 1000000, ], 'SNwkSIntKey' => [ 'type' => 'string', 'pattern' => '[a-fA-F0-9]{32}', ], 'SendDataToWirelessDeviceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'TransmitMode', 'PayloadData', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], 'TransmitMode' => [ 'shape' => 'TransmitMode', ], 'PayloadData' => [ 'shape' => 'PayloadData', ], 'WirelessMetadata' => [ 'shape' => 'WirelessMetadata', ], ], ], 'SendDataToWirelessDeviceResponse' => [ 'type' => 'structure', 'members' => [ 'MessageId' => [ 'shape' => 'MessageId', ], ], ], 'Seq' => [ 'type' => 'integer', 'max' => 16383, 'min' => 0, ], 'ServiceProfile' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ServiceProfileArn', ], 'Name' => [ 'shape' => 'ServiceProfileName', ], 'Id' => [ 'shape' => 'ServiceProfileId', ], ], ], 'ServiceProfileArn' => [ 'type' => 'string', ], 'ServiceProfileId' => [ 'type' => 'string', 'max' => 256, ], 'ServiceProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ServiceProfile', ], ], 'ServiceProfileName' => [ 'type' => 'string', 'max' => 256, ], 'SessionKeysAbpV1_0_x' => [ 'type' => 'structure', 'members' => [ 'NwkSKey' => [ 'shape' => 'NwkSKey', ], 'AppSKey' => [ 'shape' => 'AppSKey', ], ], ], 'SessionKeysAbpV1_1' => [ 'type' => 'structure', 'members' => [ 'FNwkSIntKey' => [ 'shape' => 'FNwkSIntKey', ], 'SNwkSIntKey' => [ 'shape' => 'SNwkSIntKey', ], 'NwkSEncKey' => [ 'shape' => 'NwkSEncKey', ], 'AppSKey' => [ 'shape' => 'AppSKey', ], ], ], 'SidewalkAccountInfo' => [ 'type' => 'structure', 'members' => [ 'AmazonId' => [ 'shape' => 'AmazonId', ], 'AppServerPrivateKey' => [ 'shape' => 'AppServerPrivateKey', ], ], ], 'SidewalkAccountInfoWithFingerprint' => [ 'type' => 'structure', 'members' => [ 'AmazonId' => [ 'shape' => 'AmazonId', ], 'Fingerprint' => [ 'shape' => 'Fingerprint', ], 'Arn' => [ 'shape' => 'PartnerAccountArn', ], ], ], 'SidewalkAccountList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SidewalkAccountInfoWithFingerprint', ], ], 'SidewalkListDevice' => [ 'type' => 'structure', 'members' => [ 'AmazonId' => [ 'shape' => 'AmazonId', ], ], ], 'SidewalkSendDataToDevice' => [ 'type' => 'structure', 'members' => [ 'Seq' => [ 'shape' => 'Seq', ], ], ], 'SidewalkUpdateAccount' => [ 'type' => 'structure', 'members' => [ 'AppServerPrivateKey' => [ 'shape' => 'AppServerPrivateKey', ], ], ], 'Station' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'Supports32BitFCnt' => [ 'type' => 'boolean', ], 'SupportsClassB' => [ 'type' => 'boolean', ], 'SupportsClassC' => [ 'type' => 'boolean', ], 'SupportsJoin' => [ 'type' => 'boolean', ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'Key', 'Value', ], 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 0, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 200, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'Tags', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'AmazonResourceName', 'location' => 'querystring', 'locationName' => 'resourceArn', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TargetPer' => [ 'type' => 'integer', 'max' => 100, 'min' => 0, ], 'TestWirelessDeviceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'TestWirelessDeviceResponse' => [ 'type' => 'structure', 'members' => [ 'Result' => [ 'shape' => 'Result', ], ], ], 'ThingArn' => [ 'type' => 'string', ], 'ThingName' => [ 'type' => 'string', ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'TooManyTagsException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], 'ResourceName' => [ 'shape' => 'AmazonResourceName', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'TransmitMode' => [ 'type' => 'integer', 'max' => 1, 'min' => 0, ], 'UlBucketSize' => [ 'type' => 'integer', 'max' => 2147483647, 'min' => 0, ], 'UlRate' => [ 'type' => 'integer', 'max' => 2147483647, 'min' => 0, ], 'UlRatePolicy' => [ 'type' => 'string', 'max' => 256, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'TagKeys', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'AmazonResourceName', 'location' => 'querystring', 'locationName' => 'resourceArn', ], 'TagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateDataSource' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'UpdateDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', 'location' => 'uri', 'locationName' => 'Name', ], 'ExpressionType' => [ 'shape' => 'ExpressionType', ], 'Expression' => [ 'shape' => 'Expression', ], 'Description' => [ 'shape' => 'Description', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], ], ], 'UpdateDestinationResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdatePartnerAccountRequest' => [ 'type' => 'structure', 'required' => [ 'Sidewalk', 'PartnerAccountId', 'PartnerType', ], 'members' => [ 'Sidewalk' => [ 'shape' => 'SidewalkUpdateAccount', ], 'PartnerAccountId' => [ 'shape' => 'PartnerAccountId', 'location' => 'uri', 'locationName' => 'PartnerAccountId', ], 'PartnerType' => [ 'shape' => 'PartnerType', 'location' => 'querystring', 'locationName' => 'partnerType', ], ], ], 'UpdatePartnerAccountResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateSignature' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'UpdateWirelessDeviceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessDeviceId', 'location' => 'uri', 'locationName' => 'Id', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], 'Name' => [ 'shape' => 'WirelessDeviceName', ], 'Description' => [ 'shape' => 'Description', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANUpdateDevice', ], ], ], 'UpdateWirelessDeviceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateWirelessGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayId', 'location' => 'uri', 'locationName' => 'Id', ], 'Name' => [ 'shape' => 'WirelessGatewayName', ], 'Description' => [ 'shape' => 'Description', ], ], ], 'UpdateWirelessGatewayResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateWirelessGatewayTaskCreate' => [ 'type' => 'structure', 'members' => [ 'UpdateDataSource' => [ 'shape' => 'UpdateDataSource', ], 'UpdateDataRole' => [ 'shape' => 'UpdateDataSource', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANUpdateGatewayTaskCreate', ], ], ], 'UpdateWirelessGatewayTaskEntry' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'WirelessGatewayTaskDefinitionId', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANUpdateGatewayTaskEntry', ], 'Arn' => [ 'shape' => 'WirelessGatewayTaskDefinitionArn', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'WirelessDeviceArn' => [ 'type' => 'string', ], 'WirelessDeviceId' => [ 'type' => 'string', 'max' => 256, ], 'WirelessDeviceIdType' => [ 'type' => 'string', 'enum' => [ 'WirelessDeviceId', 'DevEui', 'ThingName', ], ], 'WirelessDeviceName' => [ 'type' => 'string', 'max' => 256, ], 'WirelessDeviceStatistics' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'WirelessDeviceArn', ], 'Id' => [ 'shape' => 'WirelessDeviceId', ], 'Type' => [ 'shape' => 'WirelessDeviceType', ], 'Name' => [ 'shape' => 'WirelessDeviceName', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], 'LastUplinkReceivedAt' => [ 'shape' => 'ISODateTimeString', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANListDevice', ], 'Sidewalk' => [ 'shape' => 'SidewalkListDevice', ], ], ], 'WirelessDeviceStatisticsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WirelessDeviceStatistics', ], ], 'WirelessDeviceType' => [ 'type' => 'string', 'enum' => [ 'Sidewalk', 'LoRaWAN', ], ], 'WirelessGatewayArn' => [ 'type' => 'string', ], 'WirelessGatewayId' => [ 'type' => 'string', 'max' => 256, ], 'WirelessGatewayIdType' => [ 'type' => 'string', 'enum' => [ 'GatewayEui', 'WirelessGatewayId', 'ThingName', ], ], 'WirelessGatewayName' => [ 'type' => 'string', 'max' => 256, ], 'WirelessGatewayServiceType' => [ 'type' => 'string', 'enum' => [ 'CUPS', 'LNS', ], ], 'WirelessGatewayStatistics' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'WirelessGatewayArn', ], 'Id' => [ 'shape' => 'WirelessGatewayId', ], 'Name' => [ 'shape' => 'WirelessGatewayName', ], 'Description' => [ 'shape' => 'Description', ], 'LoRaWAN' => [ 'shape' => 'LoRaWANGateway', ], 'LastUplinkReceivedAt' => [ 'shape' => 'ISODateTimeString', ], ], ], 'WirelessGatewayStatisticsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WirelessGatewayStatistics', ], ], 'WirelessGatewayTaskDefinitionArn' => [ 'type' => 'string', ], 'WirelessGatewayTaskDefinitionId' => [ 'type' => 'string', 'max' => 36, 'pattern' => '[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', ], 'WirelessGatewayTaskDefinitionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'UpdateWirelessGatewayTaskEntry', ], ], 'WirelessGatewayTaskDefinitionType' => [ 'type' => 'string', 'enum' => [ 'UPDATE', ], ], 'WirelessGatewayTaskName' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'WirelessGatewayTaskStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'FIRST_RETRY', 'SECOND_RETRY', 'COMPLETED', 'FAILED', ], ], 'WirelessMetadata' => [ 'type' => 'structure', 'members' => [ 'LoRaWAN' => [ 'shape' => 'LoRaWANSendDataToDevice', ], 'Sidewalk' => [ 'shape' => 'SidewalkSendDataToDevice', ], ], ], ],];
